/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.arsdelight.content.jelly;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import dev.xkmc.l2core.base.tile.BaseBlockEntity;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

@SerialClass
public class JellyBlockEntity
extends BaseBlockEntity
implements GeoBlockEntity {
    private static final RawAnimation WIGGLE_SOUTH = RawAnimation.begin().then("wiggle_south", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation WIGGLE_WEST = RawAnimation.begin().then("wiggle_west", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation WIGGLE_NORTH = RawAnimation.begin().then("wiggle_north", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation WIGGLE_EAST = RawAnimation.begin().then("wiggle_east", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation[] WIGGLES = new RawAnimation[]{WIGGLE_SOUTH, WIGGLE_WEST, WIGGLE_NORTH, WIGGLE_EAST};
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int wiggleDir = -1;

    public JellyBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ResourceLocation getId() {
        return ((ResourceKey)this.getBlockState().getBlock().builtInRegistryHolder().unwrapKey().orElseThrow()).location();
    }

    public void makeWiggle(Direction dir) {
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        BlockUtil.updateObservers((Level)this.level, (BlockPos)this.getBlockPos());
        int val = dir.getAxis() == Direction.Axis.Y ? this.level.getRandom().nextInt(4) : dir.get2DDataValue();
        this.level.blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 1, val);
    }

    public boolean triggerEvent(int id, int data) {
        if (id == 1 && this.level != null && this.level.isClientSide) {
            this.wiggleDir = data;
        }
        return id == 1;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar reg) {
        reg.add(new AnimationController((GeoAnimatable)this, "wiggle", 0, this::wiggle));
    }

    private PlayState wiggle(AnimationState<GeoAnimatable> state) {
        if (this.wiggleDir >= 0) {
            RawAnimation dir = WIGGLES[this.wiggleDir];
            this.wiggleDir = -1;
            state.getController().forceAnimationReset();
            return state.setAndContinue(dir);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

